using System;
using Server.Network;

namespace Server.Items
{
	public class PoisonProofApron : LevelHalfApron
	{
		public override int ArtifactRarity{ get{ return 45; } }

		public override int BasePoisonResistance{ get{ return 15; } }
      
      [Constructable]
		public PoisonProofApron()
		{
			Weight = 2.0;
			Hue = 2609;
			Name = "<basefont color=lime>Poison-Proof Apron";
			
			SkillBonuses.SetValues( 0, SkillName.Poisoning, 10 );
			Attributes.Luck = 80;
		}
		
		public override void GetProperties(ObjectPropertyList list)
		{
			base.GetProperties(list);
			
			list.Add( "<basefont color=lime>Immunity to greater poison<basefont color=White>" );
		}

		public override bool OnEquip( Mobile from )
		{
         from.LocalOverheadMessage( MessageType.Regular, 0x3F, true, "* You feel more resilient to poisons *" );
			from.SendSound( 480 );
        	return base.OnEquip( from );
		}

		public override void OnRemoved( object parent )
		{
			if ( parent is Server.Mobiles.PlayerMobile )
			{
				Mobile m = (Mobile)parent;
				
				if ( !m.Deleted )
				{
               m.SendSound( 470 );
               //m.LocalOverheadMessage( MessageType.Regular, 0x3F, true, "* You feel the effects of your poison resistance wearing off *" );
            }
			}

	     base.OnRemoved( parent );

		}

      public PoisonProofApron(Serial serial) : base(serial)
		{
		}

		public override void Serialize( GenericWriter writer )
		{
			base.Serialize( writer );

			writer.Write( (int) 0 ); // version
		}

		public override void Deserialize( GenericReader reader )
		{
			base.Deserialize( reader );

			int version = reader.ReadInt();
		}
	}
}